/*jshint esversion: 6 */

define(["lodash"],
function (lodash) {

"use strict";

function noop () {}

var ifEnabled = lodash.partialRight(lodash.assignWith, function (dstVal, srcVal, key, dst /*, src*/) {
	if ( dst.enabled === false ) return noop;
	if ( dstVal === false ) return noop;

	return srcVal;
});

function printf (format, args, index) {
	console.logToUser(format.replace(/%s/g, function () { return args[index++]; }));
}

function sprintf (format, args, index) {
	return format.replace(/%s/g, function () { return args[index++]; });
}

return {
	printf,
	sprintf,
	ifEnabled
};

}); // end define
